/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_FILEPANELMODEFULL
#define __LCMD_FILEPANELMODEFULL

#include "lcmd/LCmdFilePanelModeAbstract.h"
#include "lcmd/LCmdFileItemContainer.h"
#include "lcmd/LCmdFilePanelColumnsBar.h"

#include "glib/gui/GDecoratedWindow.h"

/**
 * @author  Leif Erik Larsen
 * @since   2006.01.15
 */
class LCmdFilePanelModeFull : public GWindow,
                              public LCmdFilePanelModeAbstract
{
   public:

      /** The file panel containing the filenames list that we show. */
      class LCmdFilePanel& fpanel;

      /** The Columns Bar. Might be hidden (zero-size). */
      LCmdFilePanelColumnsBar columnsBar;

   public:

      /**
       * The window of where the list items are painted.
       *
       * @author  Leif Erik Larsen
       * @since   2006.01.26
       */
      class List : public GDecoratedWindow, public LCmdFileItemContainer::Listener
      {

      public:

         /** The parent window of us and our associated columns bar. */
         class LCmdFilePanelModeFull& parentWin;

         /** The Columns Bar of ours. */
         class LCmdFilePanelColumnsBar& columnsBar;
         
         /** The file panel containing the filenames list that we show. */
         class LCmdFilePanel& fpanel;

         /** The total width of all columns. */
         int totalWidthOfAllColumns;

         /** Always contain current rectangle of the file names container area. */
         GRectangle filesRect;

         /** Index of current selected item, or -1 if no item is selected. */
         int curSelectedItem;

         /** Index of first (uppermost) visible item, or -1 if there is no items in the list. */
         int firstVisibleItem;

         /** Number of items in list vertically, at least 1. */
         int itemsInListVer;

         /** X-pos of left edge of leftmost visible column (may be negative). */
         int leftMostColumnXPos;

         /** Height (pixels) of a filename item. */
         int itemHeight;

         /** Pixels height and width of a file icon (depends on icon type). */
         int iconSize;

         // TODO: ???
         int fullModeIconColumnWidth;
         int wideModeFSizeColumnWidth;
         int fullModeFDateColumnWidth;
         int fullModeFTimeColumnWidth;

         /** Width (in pixels) of the widest item filename text. */
         int widthOfWidestItemFName;

         /** Width (in pixels) of the widest item filename extention text. */
         int widthOfWidestItemFExt;

         List ( class LCmdFilePanelModeFull& parentWin );
         virtual ~List();

         virtual void allItemsHaveBeenRemoved ();

         void calcAllColumns ();

         void calcDefaultColumnWidths ();

         int calcItemIdxFromPos ( int xpos, int ypos ) const;

         bool calcItemRect ( int itemIndex, class GRectangle& rect ) const;

         void calcItems ();

         /**
         * This function will calculate and return the index of the last 
         * visible (non-clipped) item. This index will never be less than
         * {@link #firstVisibleItem}, even if that item is clipped.
         *
         * @author  Leif Erik Larsen
         * @since   2006.01.24
         */
         int calcLastVisibleItemNC () const;

         void drawItem ( int itemIndex );
         void drawItem ( int itemIndex, 
                         class GGraphics& g, 
                         const class GRectangle& itemRect, 
                         bool isDragOver = false );

         virtual void layout ();

         int navigateDown ();
         int navigateUp ();
         int navigateEnd ();
         int navigateHome ();
         int navigateLeft ();
         int navigateRight ();
         int navigatePageDown ();
         int navigatePageUp ();
         int navigateRandom ( int index );

         virtual bool onButton1Up ( int xpos, int ypos, const GWindowMessage::InputFlags& flags );
         virtual bool onButton1Down ( int xpos, int ypos, const GWindowMessage::InputFlags& flags );
         virtual bool onButton1DblClk ( int xpos, int ypos, const GWindowMessage::InputFlags& flags );
         virtual bool onButton2Click ( int xpos, int ypos, const GWindowMessage::InputFlags& flags );
         virtual bool onButton2Down ( int xpos, int ypos, const GWindowMessage::InputFlags& flags );
         virtual bool onFontNameSizeChanged ( const GString& fontNameSize );
         virtual bool onHScrollLineUp ();
         virtual bool onHScrollLineDown ();
         virtual bool onHScrollPageUp ();
         virtual bool onHScrollPageDown ();
         virtual bool onHScrollSliderTrack ( int pos );
         virtual bool onVScrollLineUp ();
         virtual bool onVScrollLineDown ();
         virtual bool onVScrollPageUp ();
         virtual bool onVScrollPageDown ();
         virtual bool onVScrollSliderTrack ( int pos );
         virtual bool onInitMenu ();
         virtual bool onMouseMove ( int xpos, int ypos, const GWindowMessage::InputFlags& flags );
         virtual bool onPaint ( class GGraphics& g, const class GRectangle& rect );

         void scrollHorizontal ( int add );
         void scrollVertical ( int add );
         
         void updateHScrollBarPos ();
         void updateScrollBarPos ();
         void updateScrollBarRange ();
         void updateVScrollBarPos ();
      };

      LCmdFilePanelModeFull::List list;

   public:

      explicit LCmdFilePanelModeFull ( class LCmdFilePanel& fpanel,
                                       const GString& winName );

      virtual ~LCmdFilePanelModeFull ();

   public:

      virtual int calcItemIdxFromPos ( int xpos, int ypos ) const;

      virtual bool calcItemRect ( int itemIndex, class GRectangle& rect ) const;

      virtual void drawItem ( int itemIndex );
      virtual void drawItem ( int itemIndex, 
                              class GGraphics& g, 
                              const class GRectangle& itemRect, 
                              bool isDragOver = false );

      virtual int getCurrentSelectedIndex () const;

      virtual int getFirstVisibleIndex () const;

      virtual GString getFontNameSize () const;

      virtual void invalidateAll ( bool inclChildren ) const;

      virtual void invalidateRect ( const GRectangle& rect ) const;

      virtual bool isHorizontallyScrollable () const;

      virtual void itemsListHasBeenRefreshed ();

      virtual void layout ();

      virtual int navigateDown ();
      virtual int navigateUp ();
      virtual int navigateEnd ();
      virtual int navigateHome ();
      virtual int navigateLeft ();
      virtual int navigateRight ();
      virtual int navigatePageDown ();
      virtual int navigatePageUp ();
      virtual int navigateRandom ( int index );

      virtual void onViewHasBeenActivated ();

      virtual GString userChooseFont ( const GString& titleText, 
                                       bool setFont, 
                                       GWindow* parentWin = null, 
                                       const GString& initialFont = GString::Empty,
                                       bool fixedOnly = false );
};

#endif // #ifndef __LCMD_FILEPANELMODEFULL
