/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "lcmd/LCmdDlgStartupTip.h"

#include "glib/GProgram.h"
#include "glib/gui/GDialogPanel.h"
#include "glib/gui/event/GDialogMessage.h"
#include "glib/gui/border/GLineBorder.h"
#include "glib/resource/GResourceTable.h"
#include "glib/util/GSectionBag.h"

LCmdDlgStartupTip::LCmdDlgStartupTip ()
{
   tipIndex = 0;
   maxCount = 0;

   // Count the number of available tip texts.
   GResourceTable& res = GProgram::GetProgram().getResourceTable();
   for (;;)
   {
      GString tipTextID("DlgStartupTip_Tip%03d", GVArgs(maxCount+1));
      if (res.getTextResource(tipTextID) == null)
         break;
      maxCount++;
   }
}

LCmdDlgStartupTip::~LCmdDlgStartupTip ()
{
}

bool LCmdDlgStartupTip::handleDialogMessage ( GDialogMessage& msg )
{
   GDialogPanel& dlg = msg.getDialog();
   switch (msg.getID())
   {
      case GM_INITDIALOG:
      {
         GColor bck = dlg.getBackgroundColor().getLighter(16, false);
         GColor frg = dlg.getForegroundColor();
         GWindow& mle = dlg.getComponentByID("TIP");
         mle.setInsets(new GInsets(4, 4, 4, 4), true);
         mle.setBorder(new GLineBorder(GLineBorder::AlignOuter), true);
         mle.setBackgroundColor(bck);
         mle.setForegroundColor(frg);
         return true;
      }

      case GM_QUERYPROFILE:
      {
         GSectionBag& ini = GProgram::GetProgram().getIniProperties();
         bool show = LCmdDlgStartupTip::ShouldShowUponStartup();
         dlg.setComponentValue("DontShow", !show, false);
         tipIndex = ini.getInt("StartupTip", "Index", tipIndex);
         dlg.sendDialogMessage(GM_COMMAND, "CmdNext");
         return true; 
      }

      case GM_WRITEPROFILE:
      {
         GSectionBag& ini = GProgram::GetProgram().getIniProperties();
         bool show = !dlg.getComponentBoolValue("DontShow");
         ini.putBool("StartupTip", "Show", show);
         ini.putInt("StartupTip", "Index", tipIndex);
         return true;
      }

      case GM_COMMAND: 
      {
         GString cmdID = msg.getParam1String();
         if (cmdID == "CmdOk")
         {
            dlg.dismiss();
         }
         else
         if (cmdID == "CmdNext")
         {
            GString tipTextID("DlgStartupTip_Tip%03d", GVArgs(++tipIndex));
            GResourceTable& res = GProgram::GetProgram().getResourceTable();
            if (res.getTextResource(tipTextID) == null)
            {
               tipIndex = 1;
               tipTextID = "DlgStartupTip_Tip001";
            }
            GStringl tipText("%" + tipTextID);
            dlg.setComponentValue("TIP", tipText, false);
            GStringl tipCount("%DlgStartupTip_TipCount", GVArgs(tipIndex).add(maxCount));
            dlg.setComponentValue("TipCount", tipCount, false);
            dlg.setComponentEnabled("CmdPrev", tipIndex > 1);
         }
         else
         if (cmdID == "CmdPrev")
         {
            GString tipTextID("DlgStartupTip_Tip%03d", GVArgs(--tipIndex));
            GResourceTable& res = GProgram::GetProgram().getResourceTable();
            if (res.getTextResource(tipTextID) == null)
            {
               tipIndex = 1;
               tipTextID = "DlgStartupTip_Tip001";
            }
            GStringl tipText("%" + tipTextID);
            dlg.setComponentValue("TIP", tipText, false);
            GStringl tipCount("%DlgStartupTip_TipCount", GVArgs(tipIndex).add(maxCount));
            dlg.setComponentValue("TipCount", tipCount, false);
            dlg.setComponentEnabled("CmdPrev", tipIndex > 1);
         }
         return true; 
      }

      default:
         return false;
   }
}

bool LCmdDlgStartupTip::ShouldShowUponStartup ()
{
   GSectionBag& ini = GProgram::GetProgram().getIniProperties();
   return ini.getBool("StartupTip", "Show", true);
}

void LCmdDlgStartupTip::Execute ( GWindow& parentWin )
{
   LCmdDlgStartupTip stip;
   GProgram& prg = GProgram::GetProgram();
   prg.executeDialog(&parentWin, "DlgStartupTip", &stip);
}
