/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_DLGFILEFILTERPROPERTIES
#define __LCMD_DLGFILEFILTERPROPERTIES

#include "glib/gui/event/GDialogMessageHandler.h"
#include "glib/primitives/GString.h"

/**
 * File item filter options.
 *
 * Objects of this type can be used by various (optional) reqursive file
 * operation commands. For example "Change Filename Case",
 * "Change File Attributes" and "Compare Directories".
 *
 * This class even has a method for letting the user edit the file filter
 * options interactively, via a modal dialog box on screen.
 * See {@link #userEditFilterOptions}.
 */
class LCmdDlgFileFilterProperties : public GDialogMessageHandler
{
   public:

      /** True if "operate on files". */
      bool inclFiles;

      /** True if "operate on directories". */
      bool inclDirs;

      /** 0=Must be off, 1=Must be on, 2=Doesn't care. */
      int flagArchive;

      /** 0=Must be off, 1=Must be on, 2=Doesn't care. */
      int flagReadOnly;

      /** 0=Must be off, 1=Must be on, 2=Doesn't care. */
      int flagHidden;

      /** 0=Must be off, 1=Must be on, 2=Doesn't care. */
      int flagSystem;

      /** True if we shall use the inclFilterStr. */
      bool useInclFilterStr;

      /** True if we shall use the exclFilterStr. */
      bool useExclFilterStr;

      /** Include files. E.g. "*.doc;*.txt". */
      GString inclFilterStr;

      /** Exclude files. E.g. "*.tmp;*.bak". */
      GString exclFilterStr;

   public:

      LCmdDlgFileFilterProperties ();
      virtual ~LCmdDlgFileFilterProperties ();

   private:

      /**
       * The message handler routine of the dialog box used by
       * {@link #userEditFilterOptions} (Dialog resource ID "DlgFileFilterProperties").
       */
      bool handleDialogMessage ( class GDialogMessage& msg );

   public:

      /**
       * With this method the user can edit the file filter options
       * interactively, via a modal dialog box on screen.
       *
       * @return True if edited successfully and user clicked the OK-button,
       *         or else false if the user clicked the Cancel-button.
       */
      bool userEditFilterOptions ( class GWindow& parentWin );
};

#endif // #ifndef __LCMD_DLGFILEFILTERPROPERTIES
