/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_DLGFILEATTRIBUTES
#define __LCMD_DLGFILEATTRIBUTES

#include "lcmd/LCmdDirProgressBase.h"

/**
 * This dialog is used by the command "Change File Attributes".
 * The command ID is <i>cmdChooseFileAttrib</i>.
 *
 * @since   2000.07.12
 * @author  Leif Erik Larsen
 */
class LCmdDlgFileAttributes : public LCmdDirProgressBase
{
   private:

      int archive;  // 0=Off, 1=On, 2=Don't change
      int hidden;   // Ditto
      int system;   // Ditto
      int readOnly; // Ditto

   public:

      explicit LCmdDlgFileAttributes ( class LCmdFilePanel& panel );
      virtual ~LCmdDlgFileAttributes ();

   protected:

      /**
       * Change the attributes of the specified file or directory item.
       *
       * Assume that the file name is not "." nor "..", and
       * that "bSkipped" will contain false upon entry.
       */
      virtual bool handleFileItem ( class LCmdFileItem* fitem, int fileIndex, bool* skipped, bool* itemUpdated );

   private:

      /**
       * A helper method for {@link #handleFileItem}.
       */
      bool updateAttr ( class LCmdFileItem& fitem, int set, int attr );

      /**
       * This is the message handler method that is called to handle
       * messages from the dialog box window.
       */
      bool handleDialogMessage ( class GDialogMessage& msg );

   public:

      /**
       * Create the dialog box of where user can edit which file attributes
       * to change. Then, if user doesn't cancel the dialog box, execute
       * the secondary thread of which to perform the update of standard
       * file attributes.
       */
      void execute ();
};

#endif // #ifndef __LCMD_DLGFILEATTRIBUTES
