/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_DLGCREATEDIRECTORY
#define __LCMD_DLGCREATEDIRECTORY

#include "glib/gui/event/GDialogMessageHandler.h"

/**
 * This dialog is used to let the user specify the name of which directory
 * to create. The user can even specify a nested directory.
 *
 * @since   2000.06.21
 * @author  Leif Erik Larsen
 */
class LCmdDlgCreateDirectory : public GDialogMessageHandler
{
   private:

      class LCmdMakeDir& makeDir;

   public:

      explicit LCmdDlgCreateDirectory ( class LCmdMakeDir& makeDir );
      virtual ~LCmdDlgCreateDirectory ();

   private:

      /**
       * This is the message handler method that is called to handle
       * messages from the dialog box window.
       */
      bool handleDialogMessage ( class GDialogMessage& msg );

   public:

      /**
       * Execute the modal dialog.
       */
      bool execute ( class GWindow& parentWin );
};

#endif // #ifndef __LCMD_DLGCREATEDIRECTORY
