/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_DLGCONFIRMFILEDELETE
#define __LCMD_DLGCONFIRMFILEDELETE

#include "glib/gui/event/GDialogMessageHandler.h"
#include "glib/gui/GMessageBox.h"

/**
 * This class defines the dialog that is used to let the user confirm a
 * file delete operation when one or more files are tagged.
 *
 * @since   2000.06.21
 * @author  Leif Erik Larsen
 */
class LCmdDlgConfirmFileDelete : public GDialogMessageHandler
{
   private:

      /** The initial confirmation text. */
      GString strQuestion;

      /** True if we should delete to the Recycle Bin or Trash Can. */
      bool trashCan;

      /** The answer that the user gave to dismiss the dialog. */
      GMessageBox::Answer answer;

   public:

      LCmdDlgConfirmFileDelete ( const GString& strQuestion, 
                                 bool trashCan );

      virtual ~LCmdDlgConfirmFileDelete ();

   private:

      /**
       * This is the message handler method that is called to handle
       * messages from the dialog box window.
       */
      bool handleDialogMessage ( class GDialogMessage& msg );

   public:

      /**
       * Execute the modal dialog.
       */
      GMessageBox::Answer execute ( class GWindow& parentWin );

      /**
       * Return true if we should delete to the Recycle Bin or Trash Can.
       */
      bool isDeleteToTrashCan () const;
};

#endif // #ifndef __LCMD_DLGCONFIRMFILEDELETE
