/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "lcmd/LCmdDlgConfirmFileDelete.h"

#include "glib/GProgram.h"
#include "glib/gui/GDialogPanel.h"
#include "glib/gui/event/GDialogMessage.h"

LCmdDlgConfirmFileDelete::LCmdDlgConfirmFileDelete ( const GString& strQuestion, 
                                                     bool trashCan )
                         :strQuestion(strQuestion),
                          trashCan(trashCan),
                          answer(GMessageBox::IDNONE)
{
}

LCmdDlgConfirmFileDelete::~LCmdDlgConfirmFileDelete () 
{
}

bool LCmdDlgConfirmFileDelete::isDeleteToTrashCan () const 
{ 
   return trashCan; 
}

GMessageBox::Answer LCmdDlgConfirmFileDelete::execute ( GWindow& parentWin )
{
   GProgram& prg = GProgram::GetProgram();
   prg.executeDialog(&parentWin, "DlgConfirmFileDelete", this);
   return answer;
}

bool LCmdDlgConfirmFileDelete::handleDialogMessage ( GDialogMessage& msg )
{
   GDialogPanel& dlg = msg.getDialog();
   switch (msg.getID())
   {
      case GM_INITDIALOG: 
      {
         if (strQuestion != "")
            dlg.setComponentValue("201", strQuestion);
         dlg.setComponentValue("105", trashCan);
         dlg.setComponentFocus("DLG_YES");
         return true; 
      }

      case GM_COMMAND: 
      {
         GString cmdID = msg.getParam1String();
         trashCan = dlg.getComponentBoolValue("105");
         if (cmdID == "DLG_YES")
            answer = GMessageBox::IDYES;
         else
         if (cmdID == "DLG_YESTOALL")
            answer = GMessageBox::IDYESTOALL;
         else
         if (cmdID == "DLG_NO" || cmdID == "DLG_CANCEL")
            answer = GMessageBox::IDCANCEL;
         dlg.dismiss(cmdID);
         return true; 
      }

      default:
         return false;
   }
}
