/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_DLGABSTRACTCMDHISTORY
#define __LCMD_DLGABSTRACTCMDHISTORY

#include "glib/gui/event/GDialogMessageHandler.h"
#include "glib/util/GArray.h"

/**
 * This class forms the base functionality of the Command- and
 * the Directory- History of Larsen Commander.
 *
 * @author  Leif Erik Larsen
 * @since   2000.06.11
 */
class LCmdDlgAbstractCmdHistory : public GObject, public GDialogMessageHandler
{
   private:

      /** The array of recent strings. */
      GArray<GString> strings;

      /** Cursor used when scrolling through strings by ^UP and ^DOWN. */
      int cursor;

      /** Title text of the dialog box. */
      GString titleStr;

   public:

      LCmdDlgAbstractCmdHistory ( int maxNum, const GString& titleStr );
      virtual ~LCmdDlgAbstractCmdHistory ();

   private:

      bool handleDialogMessage ( class GDialogMessage& msg );
      void updateHistListFromDlg ( class GDialogPanel& dlg );

   public:

      /**
       * Add the specified command to the list of recent commands.
       *
       * @return  The index of where the added string was put.
       */
      int add ( const GString& str );

      int getCursor () const;

      /**
       * Get a reference to the indexed string in the history.
       */
      const GString& getIndexedString ( int index ) const;

      /**
       * Get the current number of strings in the history.
       */
      int getStringCount () const;

      /**
       * Get a reference to the string of which to be used as the text
       * in the title bar of the dialog box.
       */
      const GString& getTitleString () const;

      /**
       * Show a list of all the text strings that are current contained in
       * the array. If user select OK the we will call <i>retrieve()</i>
       * with the selected index.
       *
       * @return  True on "OK" and success, or else false on "CANCEL"
       *          or failure.
       */
      bool pickFromDialog ();

      /**
       * Remove all strings from the history, making the history empty.
       */
      void removeAllStrings ();

      virtual bool retrieve ( int index ) = 0;

      /**
       * Scroll through the history in backward direction..
       */
      void scrollBackward ();

      /**
       * Scroll through the history in foreward direction..
       */
      void scrollForeward ();

      void setCursor ( int cursor );
};

#endif // #ifndef __LCMD_DLGABSTRACTCMDHISTORY
