/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_CMDLINEPROMPT
#define __LCMD_CMDLINEPROMPT

#include "lcmd/LCmdCmdLineButton.h"

/**
 * This class is used top form the command line prompt area to the
 * left of the command line entry window.
 *
 * The prompt class extends a button in order to let the user be able to
 * click on the prompt area to get easy access to the directory history.
 *
 * @author  Leif Erik Larsen
 * @since   2000.01.14
 */
class LCmdCmdLinePrompt : public LCmdCmdLineButton
{
   public:

      LCmdCmdLinePrompt ( class LCmdCmdLine& cmdLine, const GString& constraints );
      virtual ~LCmdCmdLinePrompt ();

   public:

      virtual GString getTooltipText () const;
      virtual int getPreferredWidth () const;
      void updatePromptText ();
};

#endif // #ifndef __LCMD_CMDLINEPROMPT
