/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_CMDLINEBUTTON
#define __LCMD_CMDLINEBUTTON

#include "glib/gui/GToolbarButton.h"

/**
 * This is the base class of the two (or possible more, - in the future)
 * buttons on the command line area.
 *
 * The main task of this class is to paint the thin line underneath the
 * button face, but only if the button has no border and the Larsen Commander
 * keybard is currently visible.
 *
 * @author  Leif Erik Larsen
 * @since   2000.01.14
 */
class LCmdCmdLineButton : public GToolbarButton
{
   protected:

      /** A reference to our parent command line window. */
      class LCmdCmdLine& cmdLine;

   public:

      LCmdCmdLineButton ( class LCmdCmdLine& cmdLine, 
                          const GString& name, 
                          const GString& constraints, 
                          const GString& id, 
                          const GString& text, 
                          const GString& iconName, 
                          const GString& userData1, 
                          ICONPOS iconPos = IP_CENTER );

      virtual ~LCmdCmdLineButton ();
};

#endif // #ifndef __LCMD_CMDLINEBUTTON
