/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/util/GToken.h"
#include "glib/primitives/GCharacter.h"

GToken::GToken ()
       :tokenStr(128),
        quoteChar('"'),
        quoted(false)
{
}

GToken::GToken ( const GString& token )
       :tokenStr(token),
        quoteChar('"'),
        quoted(token.containsWhiteSpace())
{
}

GToken::GToken ( const GToken& src )
       :tokenStr(src.tokenStr),
        quoteChar(src.quoteChar),
        quoted(src.quoted)
{
}

GToken::~GToken ()
{
}

GToken& GToken::operator= ( const GToken& src )
{
   if (&src == this)
      return *this;
   tokenStr = src.tokenStr;
   quoteChar = src.quoteChar;
   quoted = src.quoted;
   return *this;
}

bool GToken::operator== ( const GString& str ) const 
{ 
   return tokenStr == str; 
}

bool GToken::operator!= ( const GString& str ) const 
{ 
   return !operator==(str); 
}

bool GToken::isWhiteSpace ( bool ) const
{
   if (!quoted && tokenStr.length() > 0 && tokenStr[0] <= 32)
      return true;
   else
      return false;
}

GString GToken::toString ( bool inclQuotes ) const
{
   GString str = toString();
   if (!inclQuotes || !quoted)
      return str;
   GString ret(str.length() + 2);
   ret += quoteChar;
   ret += str;
   ret += quoteChar;
   return ret;
}

void GToken::clear ()
{
   tokenStr.clear();
   quoteChar = '"';
   quoted = false;
}

bool GToken::isQuoted () const 
{ 
   return quoted; 
}

char GToken::getQuoteCharacter () const 
{ 
   return quoteChar; 
}

char GToken::getCharacter ( int idx ) const 
{ 
   return tokenStr[idx]; 
}

bool GToken::isEmpty () const 
{ 
   return tokenStr.length() == 0 && !quoted; 
}

int GToken::getLength () const 
{ 
   return tokenStr.length(); 
}

GString GToken::toString () const 
{ 
   return tokenStr; 
}

void GToken::append ( char chr ) 
{ 
   tokenStr += chr; 
}
