/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_TIMESTAMP
#define __GLIB_TIMESTAMP

#include "glib/util/GDate.h"
#include "glib/util/GTime.h"

/**
 * Use this class to keep track of a time stamp (date and time).
 *
 * @author  Leif Erik Larsen
 * @since   2002.08.07
 */
class GTimeStamp : public GObject
{
   private:

      GDate date;
      GTime time;

   public:

      /**
       * Create a new time stamp object that initially contains the
       * current local date and time.
       */
      GTimeStamp ();

      /**
       * Create a new time stamp object that initially contains the
       * specified date and time.
       *
       * @author  Leif Erik Larsen
       * @since   2005.01.15
       */
      GTimeStamp ( const GDate& date, const GTime& time );

      GTimeStamp ( const FDATE& date, const FTIME& time );

      virtual ~GTimeStamp ();

   public:

      GTimeStamp& set ( const FDATE& date, const FTIME& time );

      const GTimeStamp& operator= ( const GTimeStamp& t );
      bool operator< ( const GTimeStamp& t ) const;
      bool operator> ( const GTimeStamp& t ) const;
      bool operator== ( const GTimeStamp& t ) const;
      bool operator<= ( const GTimeStamp& t ) const;
      bool operator>= ( const GTimeStamp& t ) const;
      bool operator!= ( const GTimeStamp& t ) const;

   public:

      void clear ();

      const GDate& getDate () const;
      const GTime& getTime () const;

      int getYear () const;
      int getMonth () const;
      int getDay () const;
      int getHours () const;
      int getMinutes () const;
      int getSeconds () const;
      int getMillis () const;

      void setYear ( int val );
      void setMonth ( int val );
      void setDay ( int val );
      void setHours ( int val );
      void setMinutes ( int val );
      void setSeconds ( int val );
      void setMillis ( int val );

      void setDate ( int year, int month, int day );
      void setDate ( const GDate& date );
      void setTime ( int hour, int min, int sec, int ms = 0 );
      void setTime ( const GTime& time );

      GString getDateString ( const GLocaleData* locale = null ) const;
      GString getTimeString ( bool inclSeconds = true, const GLocaleData* locale = null ) const;
      GString getTimeStampString ( bool inclSeconds = true, const GLocaleData* locale = null ) const;
      GString toString () const;
};

#endif


