/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_TIME
#define __GLIB_TIME

#include "glib/primitives/GString.h"

/**
 * Use this class to keep track of a time (clock) object.
 *
 * @author  Leif Erik Larsen
 * @since   1999.09.19
 */
class GTime : public GObject
{
   private:

      int hour;
      int min;
      int sec;
      int ms;

   public:

      /**
       * Create a new time object that initially contains the
       * current local time.
       */
      GTime ();

      GTime ( int hour, int min, int sec, int ms = 0 );

      GTime ( const FTIME& time );

      virtual ~GTime ();

   public:

      const GTime& operator= ( const FTIME& time );
      FTIME getOS2FTime () const;

      const GTime& operator= ( const GTime& t );
      bool operator< ( const GTime& t ) const;
      bool operator> ( const GTime& t ) const;
      bool operator== ( const GTime& t ) const;
      bool operator<= ( const GTime& t ) const;
      bool operator>= ( const GTime& t ) const;
      bool operator!= ( const GTime& t ) const;

   public:

      void clear ();

      int getHours () const;
      int getMinutes () const;
      int getSeconds () const;
      int getMillis () const;

      void setHours ( int val );
      void setMinutes ( int val );
      void setSeconds ( int val );
      void setMillis ( int val );

      void setTime ( int hour, int min, int sec, int ms = 0 );

      GString getTimeString ( bool inclSeconds = true, 
                              const class GLocaleData* locale = null ) const;

      GString toString () const;
};

#endif


