/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include <time.h>
#include "glib/util/GTime.h"
#include "glib/GProgram.h"

#undef min

GTime::GTime ()
      :hour(0),
       min(0),
       sec(0),
       ms(0)
{
   DATETIME dt;
   DosGetDateTime(&dt);
   hour = dt.hours;
   min = dt.minutes;
   sec = dt.seconds;
   ms = dt.hundredths * 10;
}

GTime::GTime ( int hour, int min, int sec, int ms )
      :hour(hour),
       min(min),
       sec(sec),
       ms(ms)
{
}

GTime::GTime ( const FTIME& time )
      :hour(time.hours),
       min(time.minutes),
       sec(time.twosecs * 2),
       ms(0)
{
}

GTime::~GTime ()
{
}

const GTime& GTime::operator= ( const FTIME& time )
{
   hour = time.hours;
   min = time.minutes;
   sec = time.twosecs * 2;
   ms = 0;
   return *this;
}

FTIME GTime::getOS2FTime () const
{
   FTIME time;
   memset(&time, 0, sizeof(time));
   time.hours = hour;
   time.minutes = min;
   time.twosecs = sec / 2;
   return time;
}

const GTime& GTime::operator= ( const GTime& t )
{
   hour = t.hour;
   min = t.min;
   sec = t.sec;
   ms = t.ms;
   return *this;
}

bool GTime::operator< ( const GTime& t ) const
{
   if (hour != t.hour)
      return hour < t.hour;
   else
   if (min != t.min)
      return min < t.min;
   else
   if (sec != t.sec)
      return sec < t.sec;
   else
      return ms < t.ms;
}

bool GTime::operator> ( const GTime& t ) const
{
   if (hour != t.hour)
      return hour > t.hour;
   else
   if (min != t.min)
      return min > t.min;
   else
   if (sec != t.sec)
      return sec > t.sec;
   else
      return ms > t.ms;
}

bool GTime::operator== ( const GTime& t ) const
{
   return hour == t.hour &&
          min == t.min &&
          sec == t.sec &&
          ms == t.ms;
}

bool GTime::operator<= ( const GTime& t ) const 
{ 
   return operator<(t) || operator==(t); 
}

bool GTime::operator>= ( const GTime& t ) const 
{ 
   return operator>(t) || operator==(t); 
}

bool GTime::operator!= ( const GTime& t ) const 
{ 
   return !operator==(t); 
}

void GTime::clear ()
{
   hour = 0;
   min = 0;
   sec = 0;
   ms = 0;
}

int GTime::getHours () const 
{ 
   return hour; 
}

int GTime::getMinutes () const 
{ 
   return min; 
}

int GTime::getSeconds () const 
{ 
   return sec; 
}

int GTime::getMillis () const 
{ 
   return ms; 
}

void GTime::setHours ( int val ) 
{ 
   hour = val; 
}

void GTime::setMinutes ( int val ) 
{ 
   min = val; 
}

void GTime::setSeconds ( int val ) 
{ 
   sec = val; 
}

void GTime::setMillis ( int val ) 
{ 
   ms = val; 
}

void GTime::setTime ( int hour, int min, int sec, int ms )
{
   this->hour = hour;
   this->min = min;
   this->sec = sec;
   this->ms = ms;
}

GString GTime::getTimeString ( bool inclSeconds, const GLocaleData* locale ) const
{
   if (locale == null)
   {
      const GProgram& prg = GProgram::GetProgram();
      locale = &prg.getLocaleData();
   }

   return locale->getTimeString(*this, inclSeconds);
}

GString GTime::toString () const
{
   return getTimeString(true, null);
}
