/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_LOCALEDATA
#define __GLIB_LOCALEDATA

#include "glib/primitives/GString.h"
#include "glib/util/GDate.h"
#include "glib/util/GTime.h"

/**
 * @author  Leif Erik Larsen
 * @since   2001.03.07
 */
class GLocaleData : public GObject
{
   public:

      /** Possible values for {@link #dateFormat}. */
      enum DATEFMT
      {
         DATEFMT_MM_DD_YY = 0,
         DATEFMT_DD_MM_YY = 1,
         DATEFMT_YY_MM_DD = 2,
         DATEFMT_YY_DD_MM = 3
      };

      /** Possible value for {@link #timeFormat}. */
      enum TIMEFMT
      {
         TIMEFMT_12HOUR = 0,
         TIMEFMT_24HOUR = 1
      };

      DATEFMT dateFormat;
      TIMEFMT timeFormat;
      GString timeAMString;
      GString timePMString;
      GString dateSeparator;
      GString timeSeparator;
      GString thousandsSeparator;
      GString decimalChar;

   public:

      GLocaleData ();

   private:

      static GString GetProfStr ( const char* id, const GString& defaultVal );
      static int GetProfInt ( const char* id, int def );

   public:

      /**
       * Get the current real time, formatted using "this" Country data.
       */
      GString getCurrentTimeString ( bool inclSeconds ) const;

      /**
       * Get the formatted time string ("HH:MM:SS[.mmm]") from the 
       * specified system real time in milliseconds. The specified 
       * milliseconds typically represents some "time amount", calculated 
       * from millis returned by e.g. {@link GSystem#CurrentTimeMillis}.
       * 
       * @author  Leif Erik Larsen
       * @since   2004.11.03
       * @param   millis
       * @param   inclMillis True if the returned string should include 
       *                     milliseconds, or else false if it should 
       *                     include seconds only.
       */
      GString getTimeStringFromMillis ( ulonglong millis, bool inclMillis ) const;

      /**
       * Format the specified date using the Country data, and get it
       * as a <i>GString</i>.
       */
      GString getDateString ( const class GDate& date ) const;

      /**
       * Format the specified time using the Country data, and get it
       * as a <i>GString</i>.
       */
      GString getTimeString ( const class GTime& time, bool inclSeconds ) const;
};

#endif

