/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_ISHERETRACKER
#define __GLIB_ISHERETRACKER

#include "glib/primitives/GObject.h"

/**
 * This class can be used to track whether or not the calling thread 
 * (or some other thread) is already inside a specific code block.
 *
 * @author  Leif Erik Larsen
 * @since   2004.08.04
 */
class GIsHereTracker : public GObject
{
   private:

      bool& isHere;

   public:

      GIsHereTracker ( bool& isHere, bool init );
      virtual ~GIsHereTracker ();
};

#endif
