/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_DATE
#define __GLIB_DATE

#include "glib/primitives/GString.h"

/**
 * Use this class to keep track of a date object.
 *
 * @author  Leif Erik Larsen
 * @since   2002.08.04
 */
class GDate : public GObject
{
   private:

      int year;
      int month;
      int day;

   public:

      /**
       * Create a new date object that initially contains the
       * current local date.
       */
      GDate ();

      GDate ( int year, int month, int day );

      GDate ( const FDATE& date );

      virtual ~GDate ();

   public:

      const GDate& operator= ( const FDATE& date );
      FDATE getOS2FDate () const;

      const GDate& operator= ( const GDate& d );
      bool operator< ( const GDate& d ) const;
      bool operator> ( const GDate& d ) const;
      bool operator== ( const GDate& d ) const;
      bool operator<= ( const GDate& d ) const;
      bool operator>= ( const GDate& d ) const;
      bool operator!= ( const GDate& d ) const;

   public:

      void clear ();

      int getYear () const;
      int getMonth () const;
      int getDay () const;

      void setYear ( int val );
      void setMonth ( int val );
      void setDay ( int val );

      void setDate ( int year, int month, int day );

      GString getDateString ( const class GLocaleData* locale = null ) const;
      GString toString () const;
};

#endif


