/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_SYMBOLENGINE
#define __GLIB_SYMBOLENGINE

#include "glib/primitives/GString.h"

/**
 * Class used to simplify loading of stack trace information from 
 * the Program Database file. On Win32 this is the PDB-file that is
 * produced by the linker.
 *
 * @author  Leif Erik Larsen
 * @since   2006.04.11
 */
class GSymbolEngine : public GObject
{
public:

   typedef void ThreadContext;

private:

   GSymbolEngine ();
   virtual ~GSymbolEngine ();

public:

   /** Convert the specified stack frame address to a stack trace string. */
   GString addressToString ( void* address );

   /** 
    * Provide a stack trace for the specified thread context, or for the 
    * context of the calling thread if the specified context is null.
    *
    * @author  Leif Erik Larsen
    * @since   2006.04.12
    * @param   msg  The first line (without trailing linefeed character)
    *               of text that will be part of the returned stack trace.
    *               This is typically the details message of some 
    *               typed C++ exception. If an empty string is specified 
    *               then we will produce a bare stack trace without any 
    *               such message line at the top.
    * @param   context The thread context from which to extract the 
    *               stack trace. If null is specified then we will extract 
    *               the stack trace of the currently calling thread.
    */
   static GString GetStackTrace ( const GString& msg = GString::Empty, 
                                  GSymbolEngine::ThreadContext* context = null );
};

#endif
