/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_RCTOKEN
#define __GLIB_RCTOKEN

#include "glib/util/GAbstractToken.h"

/**
 * This class is used as the return type of {@link GRcTokenizer#getNextToken}.
 *
 * @author  Leif Erik Larsen
 * @since   2000.09.04
 */
class GRcToken : public GAbstractToken
{
   friend class GRcTokenizer;

   private:

      GString tokenStr;
      char quoteChar;
      bool quoted;

   public:

   public:

      /**
       * Create a new token that is initially empty.
       */
      GRcToken ();

      /**
       * Create a new token that initially contains the specified string.
       */
      explicit GRcToken ( const GString& token );

      /**
       * Create a new token that is initially equal to the specified token.
       */
      GRcToken ( const GRcToken& src );

      virtual ~GRcToken ();

   public:

      GRcToken& operator= ( const GRcToken& src );

      /**
       * Return true if the current token equals the specified String.
       * We will return true if, and only if, the specified string is 100%
       * equal to the current token.
       */
      virtual bool operator== ( const GString& str ) const;

      bool operator!= ( const GString& str ) const;

      GRcToken& operator+= ( char chr );

      operator const char* () const;

      /**
       * @see GAbstractToken#isQuoted
       */
      virtual bool isQuoted () const;

      /**
       * @see GAbstractToken#getQuoteCharacter
       */
      virtual char getQuoteCharacter () const;

      /**
       * @see GAbstractToken#getCharacter
       */
      virtual char getCharacter ( int idx ) const;

      /**
       * @see GAbstractToken#isEmpty
       */
      virtual bool isEmpty () const;

      /**
       * @see GAbstractToken#getLength
       */
      virtual int getLength () const;

      /**
       * Implements {@link GAbstractToken#toString}.
       *
       * @see     #getString
       */
      virtual GString toString () const;

      /**
       * Use this method instead of {@link #toString} when called from
       * an object that sees the <i>GRcToken</i> directly (rather than the
       * abstract {@link GAbstractToken}). For speed optimizing reasons.
       *
       * @author  Leif Erik Larsen
       * @since   2000.09.08
       * @see     #toString
       */
      const GString& getString () const;

      /**
       * Clear the current token.
       */
      void clear ();
};

#endif


