/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_MENURESOURCE
#define __GLIB_MENURESOURCE

#include "glib/resource/GMenuPopupParams.h"

/**
 * Each MENU resource is represented with an instance of this class.
 */
class GMenuResource : public GMenuPopupParams
{
   public:

      explicit GMenuResource ( const GString& id );

   public:

      /**
       * Load and compile the following resource definition from the
       * specified tokenizer for the calling resource compiler.
       *
       * Since we assume that the ID-part of the resource has already been
       * parsed the next token (which is the first, from our point of view)
       * returned from the tokenizer must be "(".
       *
       * @author  Leif Erik Larsen
       * @since   2000.09.08
       * @param   tokenizer   The tokenizer of where to get tokens to parse.
       * @throws  GRcException in case of any error.
       */
      virtual void loadFromScript ( class GRcTokenizer& tokenizer, 
                                    class GResourceTable* table );
};

#endif


