/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include <limits.h>
#include "glib/primitives/GUInteger.h"

const unsigned int GUInteger::MIN_VALUE = 0;
const unsigned int GUInteger::MAX_VALUE = UINT_MAX;

GUInteger::GUInteger () 
          :value(0) 
{
}

GUInteger::GUInteger ( const GUInteger& val ) 
          :value(val.value) 
{
}

GUInteger::GUInteger ( unsigned int val ) 
          :value(val) 
{
}

GUInteger::~GUInteger ()
{
}

int GUInteger::hashCode () const
{
   return value;
}

bool GUInteger::equals ( const GObject& obj ) const
{
   if (&obj == this)
      return true;
   const GUInteger* o = dynamic_cast<const GUInteger*>(&obj);
   if (o != null)
      return value == o->value;
   return false;
}

unsigned int GUInteger::ParseUInt ( const GString& str, short radix )
{
   return GIntegerNumber<unsigned int>::ParseUnsigned(str, MAX_VALUE, radix);
}

GString GUInteger::toString () const
{
   return GIntegerNumber<unsigned int>::ToUnsignedString(value);
}

GString GUInteger::ToString ( unsigned int value, short radix, int width, char padChar )
{
   return GIntegerNumber<unsigned int>::ToUnsignedString(value, radix, width, padChar);
}
