/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_RECTANGLE
#define __GLIB_RECTANGLE

#include "glib/primitives/GPoint.h"
#include "glib/primitives/GDimension.h"

/**
 * Primitive class used to represent a rectangle area, typically within a
 * window or text area on screen.
 *
 * @author  Leif Erik Larsen
 * @since   1999.09.13
 */
class GRectangle : public GObject
{
   public:

      int x;
      int y;
      int width;
      int height;

   public:

      GRectangle ();
      GRectangle ( int x, int y, int width, int height );
      GRectangle ( const GRectangle& rect );
      GRectangle ( const GDimension& dim );
      
      virtual ~GRectangle ();

   public:

      GRectangle& operator= ( const GRectangle& rect );
      bool operator== ( const GRectangle& rect );
      bool operator!= ( const GRectangle& rect );

   private:

      GRectangle& copyFrom ( const GRectangle& rect );

   public:

      GRectangle& clear ();
      bool equals ( const GRectangle& rect );
      GRectangle& inflateRect ( int hor, int ver );
      GRectangle& inflateRect ( int horver );

      /**
       * Return true if and only if the specified position falls within 
       * the area defined by the rectangle.
       *
       * @author  Leif Erik Larsen
       * @since   2005.12.13
       */
      bool isPointInRect ( int xpos, int ypos ) const;

      /** Nudge X, adjusting the width correspondingly. */
      GRectangle& nudgeX ( int addX );
      GRectangle& nudgeY ( int addY );

      void setBounds ( int x, int y, int width, int height );

      /**
       * Return a string representation of the rectangle, for debugging
       * purposes only.
       */
      GString toString () const;
};

#endif

