/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_NUMBER
#define __GLIB_NUMBER

#include "glib/primitives/GObject.h"

/**
 * This is the abstract base class for every class that is
 * used to wrap a primitive number, such as e.g. GInteger, GFloat
 * GBoolean and GCharacter.
 *
 * @author  Leif Erik Larsen
 * @since   2000.10.23
 */
class GNumber : public GObject
{
   protected:

      GNumber ();
      GNumber ( const GNumber& src );

      virtual ~GNumber ();

   public:

      virtual bool boolValue () const = 0;
      virtual char charValue () const = 0;
      virtual short shortValue () const = 0;
      virtual int intValue () const = 0;
      virtual longlong longValue () const = 0;
      virtual unsigned short ushortValue () const = 0;
      virtual unsigned int uintValue () const = 0;
      virtual ulonglong ulongValue () const = 0;
      virtual float floatValue () const = 0;
      virtual double doubleValue () const = 0;

      /**
       * Make this method pure virtual in order to force all 
       * our subclasses to override it from {@link GObject#toString}.
       *
       * @author  Leif Erik Larsen
       * @since   2000.10.23
       */
      virtual GString toString () const = 0;
};

#endif


