/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/primitives/GInsets.h"
#include "glib/primitives/GVArgs.h"

GInsets::GInsets ()
{
   this->top = 0;
   this->left = 0;
   this->bottom = 0;
   this->right = 0;
}

GInsets::GInsets ( int top, int left, int bottom, int right )
{
   this->top = top;
   this->left = left;
   this->bottom = bottom;
   this->right = right;
}

GInsets::GInsets ( const GInsets& ins )
{
   this->top = ins.top;
   this->left = ins.left;
   this->bottom = ins.bottom;
   this->right = ins.right;
}

GInsets::~GInsets ()
{
}

GInsets& GInsets::clear ()
{
   top = 0;
   left = 0;
   bottom = 0;
   right = 0;
   return *this;
}

GInsets& GInsets::operator= ( const GInsets& src ) 
{ 
   if (&src == this)
      return *this;
   top = src.top;
   left = src.left;
   bottom = src.bottom;
   right = src.right;
   return *this;
}

bool GInsets::operator== ( const GInsets& src )
{
   return top == src.top &&
          left == src.left &&
          bottom == src.bottom &&
          right == src.right;
}

bool GInsets::operator!= ( const GInsets& src )
{
   return !operator==(src);
}

GInsets& GInsets::copyFrom ( const GInsets& ins )
{
   if (&ins == this)
      return *this;
   top = ins.top;
   left = ins.left;
   bottom = ins.bottom;
   right = ins.right;
   return *this;
}

GString GInsets::toString () const
{
   return GString("[l=%d, r=%d, b=%d, t=%d]", GVArgs(left).add(right).add(bottom).add(top));
}


