/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/primitives/GFloatNumber.h"

GFloatNumber::GFloatNumber () 
{
}

GFloatNumber::GFloatNumber ( const GFloatNumber& src ) 
             :GNumber(src) 
{
}

GFloatNumber::~GFloatNumber ()
{
}

int GFloatNumber::compareObj ( const GObject& obj ) const
{
   const GNumber* num = dynamic_cast<const GNumber*>(&obj);
   if (num == null)
      return 1; // Don't know how to compare, so return "this < obj".
   double v1 = doubleValue();
   double v2 = num->doubleValue();
   if (v1 < v2)
      return -1;
   if (v1 > v2)
      return +1;
   return 0;
}
