/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include <float.h>
#include <stdio.h>
#include <stdlib.h>
#include "glib/primitives/GDouble.h"
#include "glib/primitives/GVArgs.h"
#include "glib/exceptions/GNumberFormatException.h"

const double GDouble::MIN_VALUE = DBL_MIN;
const double GDouble::MAX_VALUE = DBL_MAX;

GDouble::GDouble ( const char* str )
        :value(GDouble::ParseDouble(str))
{
}

GDouble::~GDouble ()
{
}

int GDouble::hashCode () const
{
   longlong l = longlong(value);
   return int(l ^ (l >> 32));
}

bool GDouble::equals ( const GObject& obj ) const
{
   if (&obj == this)
      return true;
   const GDouble* o = dynamic_cast<const GDouble*>(&obj);
   if (o != null)
      return value == o->value;
   return false;
}

double GDouble::ParseDouble ( const GString& str )
{
   char *endptr;
   double ret = strtod(str.cstring(), &endptr);
   if (*endptr != '\0')
      gthrow_(GNumberFormatException(str));
   return ret;
}

GString GDouble::toString () const
{
   return GDouble::ToString(value);
}

GString GDouble::ToString ( double val, bool expForm )
{
   if (expForm)
      return GString("%E", GVArgs(val));
   else
      return GString("%f", GVArgs(val));
}

