/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_CHARACTER
#define __GLIB_CHARACTER

#include "glib/primitives/GNumber.h"

/**
 * A general character representation class.
 *
 * @author  Leif Erik Larsen
 * @since   1999.09.18
 */
class GCharacter : public GNumber
{
   private:

      char value;

   public:

      GCharacter () : value('\0') {}
      GCharacter ( char value ) : value(value) {}
      GCharacter ( const GCharacter& value ) : value(value) {}

      virtual ~GCharacter ();

   public:

      operator char () const { return value; }

   public:

      virtual bool boolValue () const { return value == '\0' ? false : true; }
      virtual char charValue () const { return value; }
      virtual short shortValue () const { return short(value); }
      virtual int intValue () const { return int(value); }
      virtual longlong longValue () const { return longlong(value); }
      virtual unsigned short ushortValue () const { return (unsigned short) value; }
      virtual unsigned int uintValue () const { return (unsigned int) value; }
      virtual ulonglong ulongValue () const { return (ulonglong) value; }
      virtual float floatValue () const { return float(int(value)); }
      virtual double doubleValue () const { return double(long(value)); }

      virtual bool isUnsigned () const;

      /**
       * Compares two GCharacter's for sorting algorithms, etc., using 
       * the values returned by {@link GNumber#uintValue} or 
       * {@link GNumber#intValue}, if {@link #isUnsigned} returns 
       * true or false respectively.
       *
       * @author  Leif Erik Larsen
       * @since   2004.03.14
       * @param   obj  The object of which to compare to.
       *               Must be an instance of {@link GNumber}.
       * @see     GArrayImpl#compare2Objects
       * @see     GComparator
       */
      virtual int compareObj ( const GObject& obj ) const;

   public:

      static int Digit ( char ch );
      static bool IsDigit ( char ch );
      static bool IsLetter ( char ch );
      static bool IsLetterOrDigit ( char ch );
      static bool IsWhiteSpace ( char ch );
      static GString ToString ( char chr );
      static char ToLowerCase ( char ch );
      static char ToUpperCase ( char ch );

      virtual GString toString () const;
};

#endif


