/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/primitives/GBoolean.h"
#include "glib/primitives/GDouble.h"
#include "glib/exceptions/GNumberFormatException.h"

const GBoolean GBoolean::True(true);
const GBoolean GBoolean::False(false);
const GString GBoolean::TrueStr("true");
const GString GBoolean::FalseStr("false");

GBoolean::~GBoolean ()
{
}

int GBoolean::hashCode () const
{
   return value ? 1231 : 1237;
}

bool GBoolean::equals ( const GObject& obj ) const
{
   if (&obj == this)
      return true;
   const GBoolean* o = dynamic_cast<const GBoolean*>(&obj);
   if (o != null)
      return value == o->value;
   return false;
}

const GBoolean& GBoolean::GetBoolean ( bool b ) 
{ 
   return b ? True : False; 
}

const GString& GBoolean::GetBooleanStr ( bool b ) 
{ 
   return b ? TrueStr : FalseStr; 
}

GString GBoolean::ToString ( bool val )
{
   return GetBooleanStr(val);
}

GString GBoolean::toString () const
{
   return GString(value ? "true" : "false");
}

bool GBoolean::ParseBoolean ( const GString& str, bool def )
{
   if (str == "")
   {
      return def;
   }
   else
   if (str == "1" ||
       str.equalsIgnoreCase("true") ||
       str.equalsIgnoreCase("yes") ||
       str.equalsIgnoreCase("on"))
   {
      return true;
   }
   else
   if (str == "0" ||
       str.equalsIgnoreCase("false") ||
       str.equalsIgnoreCase("no") ||
       str.equalsIgnoreCase("off"))
   {
      return false;
   }
   else
   {
      try {
         double val = GDouble::ParseDouble(str);
         if (val != 0.0)
            return true;
         else
            return false;
      } catch (GNumberFormatException& /*e*/) {
         return def;
      }
   }
}

int GBoolean::compareObj ( const GObject& obj ) const
{
   const GNumber* num = dynamic_cast<const GNumber*>(&obj);
   if (num == null)
      return 1; // Don't know how to compare, so return "this < obj".
   bool b1 = boolValue();
   bool b2 = num->boolValue();
   if (b1 == b2)
      return 0;
   else
      return +1;
}

