/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_CENTERLAYOUT
#define __GLIB_CENTERLAYOUT

#include "glib/gui/layout/GLayoutManager.h"

/**
 * Use this layout manager to layout one single child window to occupy all
 * parts of the client area of its parent window.
 *
 * @author  Leif Erik Larsen
 * @since   2000.01.04
 * @see     GWindow#setLayoutManager
 */
class GCenterLayout : public GLayoutManager
{
   public:

      GCenterLayout ();
      virtual ~GCenterLayout ();

   public:

      /**
       * @see GLayoutManager#preferredLayoutSize
       */
      GDimension preferredLayoutSize ( GWindow& parent );

      /**
       * @see GLayoutManager#preferredLayoutWidth
       */
      int preferredLayoutWidth ( GWindow& parent );

      /**
       * @see GLayoutManager#preferredLayoutHeight
       */
      int preferredLayoutHeight ( GWindow& parent );

      /**
       * @see GLayoutManager#layoutWindow
       */
      void layoutWindow ( GWindow& parent );
};

#endif

