/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_MOUSEEVENT
#define __GLIB_MOUSEEVENT

#include "glib/gui/event/GWindowMessage.h"

/**
 * An event which indicates that a mouse action occurred in a component.
 * The contained properties of the event defines the state of the mouse 
 * and input devices as of when the mouse event occured.
 *
 * @author  Leif Erik Larsen
 * @since   2004.06.30
 * @see     GMouseListener
 */
class GMouseEvent : public GObject
{
   public:

      /**
       * The mouse buttin identifyers supported by this class.
       *
       * @author  Leif Erik Larsen
       * @since   2004.06.30
       */
      enum ButtonId
      {
         /** 
          * Indicates mouse button #1; used by {@link #getButton}. 
          * This is usually the left mouse button.
          */
         BUTTON1,

         /** 
          * Indicates mouse button #2; used by {@link #getButton}. 
          * This is usually the right mouse button.
          */
         BUTTON2,

         /** 
          * Indicates mouse button #3; used by {@link #getButton}. 
          * This is usually the middle mouse button.
          */
         BUTTON3
      };

      /** The horizontal position (in pixels) of the mouse cursor. */
      const int xpos;

      /** The vertical position (in pixels) of the mouse cursor. */
      const int ypos;

      /** The input flags as of when the mouse event occured. */
      const GWindowMessage::InputFlags flags;

      const ButtonId buttonId;

   public:

      GMouseEvent ( int xpos, 
                    int ypos, 
                    const GWindowMessage::InputFlags& flags,
                    ButtonId buttonId );

      virtual ~GMouseEvent ();

      ButtonId getButtonId () const;
};

#endif
