/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/event/GDialogMessage.h"
#include "glib/util/GLog.h"

GDialogMessage::GDialogMessage ( GDialogPanel& dlg, 
                                 GDialogMessageHandler::MessageID id, 
                                 GObject* param1, 
                                 GObject* param2 )
               :GUserMessage(param1, param2),
                id(id),
                dlg(dlg)
{
}

GDialogMessage::GDialogMessage ( GDialogPanel& dlg, 
                                 GDialogMessageHandler::MessageID id, 
                                 const GString& str1, 
                                 GObject* param2 )
               :GUserMessage(str1, param2),
                id(id),
                dlg(dlg)
{
}

GDialogMessage::GDialogMessage ( GDialogPanel& dlg, 
                                 GDialogMessageHandler::MessageID id, 
                                 const GString& str1, 
                                 const GString& str2 )
               :GUserMessage(str1, str2),
                id(id),
                dlg(dlg)
{
}

GDialogMessage::~GDialogMessage ()
{
}

GDialogMessageHandler::MessageID GDialogMessage::getID () const 
{ 
   return id; 
}

GDialogPanel& GDialogMessage::getDialog () 
{ 
   return dlg; 
}

GString GDialogMessage::toString () const
{
   GString msgName;
   switch (id)
   {
      case GDialogMessageHandler::GM_INITDIALOG: msgName = "GM_INITDIALOG"; break;
      case GDialogMessageHandler::GM_DISMISSDIALOG: msgName = "GM_DISMISSDIALOG"; break;
      case GDialogMessageHandler::GM_CTRLCHANGED: msgName = "GM_CTRLCHANGED"; break;
      case GDialogMessageHandler::GM_FOCUSLOSS: msgName = "GM_FOCUSLOSS"; break;
      case GDialogMessageHandler::GM_FOCUSSET: msgName = "GM_FOCUSSET"; break;
      case GDialogMessageHandler::GM_CTRLNOTIFY: msgName = "GM_CTRLNOTIFY"; break;
      case GDialogMessageHandler::GM_QUERYPROFILE: msgName = "GM_QUERYPROFILE"; break;
      case GDialogMessageHandler::GM_WRITEPROFILE: msgName = "GM_WRITEPROFILE"; break;
      case GDialogMessageHandler::GM_COMMAND: msgName = "GM_COMMAND"; break;
      case GDialogMessageHandler::GM_CLOSEWIN: msgName = "GM_CLOSEWIN"; break;
      case GDialogMessageHandler::GM_LISTBOX_DBLCLICK: msgName = "GM_LISTBOX_DBLCLICK"; break;
      case GDialogMessageHandler::GM_TIMER: msgName = "GM_TIMER"; break;
      case GDialogMessageHandler::GM_USER: msgName = "GM_USER"; break;
      default: msgName = GString("GM_USER%c%d", GVArgs(id>GDialogMessageHandler::GM_USER?'+':'-').add(id - GDialogMessageHandler::GM_USER)); break;
   }
   return GString("%s, p1=\"%s\", p2=\"%s\"", GVArgs(msgName).add(getParam1String()).add(getParam2String()));
}

