/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_ETCHEDBORDER
#define __GLIB_ETCHEDBORDER

#include "glib/gui/border/GBorder.h"

/**
 * A simple three-pixel wide etched border.
 *
 * @author  Leif Erik Larsen
 * @since   2004.09.18
 */
class GEtchedBorder : public GBorder
{
   private:

      bool down;

   public:

      GEtchedBorder ( bool down = false );
      virtual ~GEtchedBorder ();

   protected:

      /**
       * @author  Leif Erik Larsen
       * @since   2004.09.18
       */
      virtual void paintTheBorder ( class GGraphics& g,
                                    const class GRectangle& rect, 
                                    const class GInsets& ins ) const;
};

#endif
