/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/border/GEtchedBorder.h"
#include "glib/gui/GGraphics.h"
#include "glib/primitives/GInsets.h"
#include "glib/exceptions/GIllegalArgumentException.h"

GEtchedBorder::GEtchedBorder ( bool down )
              :down(down)
{
}

GEtchedBorder::~GEtchedBorder ()
{
}

void GEtchedBorder::paintTheBorder ( GGraphics& g,
                                     const GRectangle& rect, 
                                     const GInsets& ins ) const
{
   // Since this is a fixed three-pixel wide border we don't need to clear
   // any background area is all insets are three-pixel wide.
   if (ins.left > 3 || ins.right > 3 || ins.top > 3 || ins.bottom > 3)
      paintBackGround(g);

   // ---
   int left = rect.x;
   int bottom = rect.y;
   int right = left + rect.width - 1;
   int top = bottom + rect.height - 1;

   g.setColor(GColor::GRAY);
   g.drawPixel(left, bottom);
   g.drawPixel(right, top);
   g.drawPixel(right - 2, top - 2);

   g.setColor(down ? GColor::WHITE : GColor::DGRAY);
   g.setPosition(left, bottom + 1);
   g.drawLineTo(left, top);
   g.drawLineTo(right - 1, top);

   g.setColor(down ? GColor::DGRAY : GColor::WHITE);
   g.setPosition(right, top - 1);
   g.drawLineTo(right, bottom);
   g.drawLineTo(left + 1, bottom);

   g.setColor(GColor::GRAY);
   g.setPosition(left + 1, bottom + 1);
   g.drawLineTo(left + 1, top - 1);
   g.drawLineTo(right - 1, top - 1);
   g.drawLineTo(right - 1, bottom + 1);
   g.drawLineTo(left + 1, bottom + 1);

   g.setColor(down ? GColor::DGRAY : GColor::WHITE);
   g.setPosition(left + 2, bottom + 2);
   g.drawLineTo(left + 2, top - 2);
   g.drawLineTo(right - 2, top - 2);

   g.setColor(down ? GColor::WHITE : GColor::DGRAY);
   g.setPosition(right - 2, top - 3);
   g.drawLineTo(right - 2, bottom + 2);
   g.drawLineTo(left + 2, bottom + 2);
}
