/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/border/GEmptyBorder.h"
#include "glib/gui/GGraphics.h"
#include "glib/primitives/GInsets.h"

GEmptyBorder::GEmptyBorder ()
             :color(null)
{
}

GEmptyBorder::GEmptyBorder ( const class GColor& color )
             :color(new GColor(color))
{
}

GEmptyBorder::~GEmptyBorder ()
{
   delete color;
}

void GEmptyBorder::paintTheBorder ( GGraphics& g,
                                    const GRectangle& rect, 
                                    const GInsets& ins ) const
{
   if (color != null)
      g.setColor(*color);
   paintBackGround(g);
}
