/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_WINDOWCLASS
#define __GLIB_WINDOWCLASS

#include "glib/primitives/GString.h"

/**
 * This class is used by <i>GWindow</i> in order to keep track of the
 * window class name, as seen by the underlying system, regardless of
 * if it is a true string (application specific window class) or a
 * predefined system dependent window class id (such as for instance
 * WC_MLE, WC_SCROLLBAR, etc.).
 *
 * @author  Leif Erik Larsen
 * @since   2000.01.06
 */
class GWindowClass : public GObject
{
   public:

      /** The generic window class for all GLib-defined windows. */
      static const GWindowClass GENERIC;

      /** System defined Multiline Editor Window Class. */
      static const GWindowClass MLE;

      /** System defined Text Entry Window Class. */
      static const GWindowClass ENTRYFIELD;

      /** System defined Scrollbar Window Class. */
      static const GWindowClass SCROLLBAR;

      /** System defined Push-/Toggle-/Radio- Button Class. */
      static const GWindowClass BUTTON;

      /** System defined ListBox Class. */
      static const GWindowClass LISTBOX;

      /** System defined Tabbed-Panel Window Class. */
      static const GWindowClass TABBEDPANEL;

      /** System defined Spinner Class. */
      static const GWindowClass SPINNER;

      /** System defined TreeView Class. */
      static const GWindowClass TREE;

      /** System defined Menu Window Class. */
      static const GWindowClass MENU;

   private:

      /** The class name as seen by the application code. */
      GString className;

      /** True if class name is one of the system predefined classes. */
      bool sysClass;

      /** The class name as of which to be seen by the underlying system. */
      const char* systemClassID;

   private:

      GWindowClass ( const char* name, bool isSysClass );
      GWindowClass ( const GWindowClass& src ) {}
      virtual ~GWindowClass ();

   public:

      bool operator== ( const GWindowClass& src ) const { return &src == this; }

   public:

      const GString& getClassName () const { return className; }
      const char* getSystemClassID () const { return systemClassID; }
      bool isSystemClass () const { return sysClass; }
};

#endif

