/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/GWindowClass.h"
#include "glib/gui/GWindow.h"
#include "glib/GProgram.h"

const GWindowClass GWindowClass::GENERIC("GWindow", false);
const GWindowClass GWindowClass::MLE(WC_MLE, true);
const GWindowClass GWindowClass::ENTRYFIELD(WC_ENTRYFIELD, true);
const GWindowClass GWindowClass::SCROLLBAR(WC_SCROLLBAR, true);
const GWindowClass GWindowClass::BUTTON(WC_BUTTON, true);
const GWindowClass GWindowClass::LISTBOX(WC_LISTBOX, true);
const GWindowClass GWindowClass::SPINNER(WC_SPINBUTTON, true);
const GWindowClass GWindowClass::TABBEDPANEL(WC_NOTEBOOK, true);
const GWindowClass GWindowClass::TREE(WC_CONTAINER, true);
const GWindowClass GWindowClass::MENU(WC_MENU, true);

GWindowClass::GWindowClass ( const char* name, bool isSysClass )
{
   if (((int) name & 0xFFFF0000) == 0xFFFF0000)
      sysClass = true;
   else
      sysClass = isSysClass;
   if (sysClass)
   {
      systemClassID = name;
      if (name == WC_FRAME)      // Application frame control.
         className = "WC_FRAME";
      else
      if (name == WC_STATIC)     // Text and group boxes.
         className = "WC_STATIC";
      else
      if (name == WC_BUTTON)     // Push button, check box or radio button.
         className = "WC_BUTTON";
      else
      if (name == WC_COMBOBOX)   // Combination of an entry field and list box.
         className = "WC_COMBOBOX";
      else
      if (name == WC_ENTRYFIELD) // Single line entry field.
         className = "WC_ENTRYFIELD";
      else
      if (name == WC_MLE)        // Multiple line entry field.
         className = "WC_MLE";
      else
      if (name == WC_LISTBOX)    // List box.
         className = "WC_LISTBOX";
      else
      if (name == WC_MENU)       // Application action bar, menus and popup menus.
         className = "WC_MENU";
      else
      if (name == WC_SCROLLBAR)  // Horizontal or vertical scroll bar.
         className = "WC_SCROLLBAR";
      else
      if (name == WC_TITLEBAR)   // Application title bar.
         className = "WC_TITLEBAR";
      else
      if (name == WC_SPINBUTTON) // Spin button entry field.
         className = "WC_SPINBUTTON";
      else
      if (name == WC_CONTAINER)  // Container list.
         className = "WC_CONTAINER";
      else
      if (name == WC_SLIDER)     // Horizontal or vertical slider control.
         className = "WC_SLIDER";
      else
      if (name == WC_VALUESET)   // Value set control.
         className = "WC_VALUESET";
      else
      if (name == WC_NOTEBOOK)   // Notebook control.
         className = "WC_NOTEBOOK";
      else
      if (name == WC_CONTAINER)  // Container/Tree control.
         className = "WC_CONTAINER";
      else
         className = "";
   }
   else
   {
      if (name != null)
         className = name;
      systemClassID = className;
      ::WinRegisterClass(GProgram::hAB, 
                         className,
                         GWindow::GenericWindowProc, 
                         CS_CLIPCHILDREN | CS_CLIPSIBLINGS,
                         sizeof(GObject*) + 4);
   }
}

GWindowClass::~GWindowClass ()
{
}
