/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_USERSTRINGDLG
#define __GLIB_USERSTRINGDLG

#include "glib/primitives/GString.h"
#include "glib/gui/event/GDialogMessageHandler.h"

/**
 * Utility class that can be used to display a simple dialog with a
 * text entry field and two buttons; OK and Cancel, where the user can
 * type in any text of which to be returned to the application code when
 * the user press the OK button.
 *
 * @author  Leif Erik Larsen
 * @since   2000.04.05
 */
class GUserStringDlg : public GDialogMessageHandler
{
   private:

      GString titleText;
      GString leaderText;
      GString text;
      int maxTextLen;

   private:

      GUserStringDlg ( const GString& titleText, 
                       const GString& leaderText,
                       const GString& text, 
                       int maxTextLen );

   public:

      virtual ~GUserStringDlg () {}

   private:

      /**
       * This is the message handler method that is called to handle
       * messages from the dialog box window.
       *
       * Part of the interface {@link GDialogMessageHandler}.
       */
      bool handleDialogMessage ( class GDialogMessage& msg );

   public:

      /**
       * Show a modal dialog box of where the user can type in a text string
       * that will be returned from this method when the user clicks on
       * the OK-button.
       *
       * @param  parentWin   Parent window, or null if no parent.
       * @param  titleStr    The text to be used as the title string of the
       *                     dialog.
       * @param  leaderStr   The text to show in the text entry leader field.
       * @param  defaultStr  The default string will be automatically
       *                     put into the entry field initially.
       * @param  cancelStr   This string will be returned in case the user
       *                     clicks on the Cancel-button.
       * @param  maxLength   Maximum number of characters in the returned
       *                     string. Zero means "no limit".
       */
      static GString Get ( class GWindow* parentWin, 
                           const GString& titleStr, 
                           const GString& leaderStr,
                           const GString& defaultStr = GString::Empty, 
                           const GString& cancelStr = GString::Empty, 
                           int maxLength = 0 );
};

#endif

