/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/GUserStringDlg.h"
#include "glib/gui/GDialogFrame.h"
#include "glib/gui/GDialogPanel.h"
#include "glib/gui/GTextEntry.h"
#include "glib/gui/event/GDialogMessage.h"
#include "glib/GProgram.h"

GUserStringDlg::GUserStringDlg ( const GString& titleText, 
                                 const GString& leaderText,
                                 const GString& text, 
                                 int maxTextLen )
               :titleText(GProgram::LoadText(titleText)),
                leaderText(GProgram::LoadText(leaderText)),
                text(text),
                maxTextLen(maxTextLen <= 0 ? 1024 : maxTextLen)
{
   if (this->text.length() > this->maxTextLen)
      this->text.cutTailFrom(this->maxTextLen);
}

bool GUserStringDlg::handleDialogMessage ( GDialogMessage& msg )
{
   GDialogPanel& dlg = msg.getDialog();
   switch (msg.getID())
   {
      case GM_INITDIALOG:
      {
         dlg.getOwnerFrame().setText(titleText);
         dlg.setComponentText("LEADER", leaderText);
         GTextEntry& entry = dynamic_cast<GTextEntry&>(dlg.getComponentByID("101"));
         entry.setMaxTextLength(maxTextLen);
         entry.setText(text);
         return true;
      }

      case GM_COMMAND: 
      {
         GString cmdID = msg.getParam1String();
         if (cmdID == "DLG_OK")
         {
            text = dlg.getComponentValue("101");
            dlg.dismiss(cmdID);
         }
         else
         if (cmdID == "DLG_CANCEL")
         {
            dlg.dismiss(cmdID);
         }
         return true; 
      }

      default:
         return false;
   }
}

GString GUserStringDlg::Get ( GWindow* parentWin, 
                              const GString& titleStr, 
                              const GString& leaderStr,
                              const GString& defaultStr, 
                              const GString& cancelStr, 
                              int maxLength )
{
   GUserStringDlg ed(titleStr, leaderStr, defaultStr, maxLength);
   GProgram& prg = GProgram::GetProgram();
   GString darg = prg.executeDialog(parentWin, "DlgUserString", &ed);
   if (darg == "DLG_OK")
      return ed.text;
   else
      return cancelStr;
}
