/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_TOOLBARSEPARATOR
#define __GLIB_TOOLBARSEPARATOR

#include "glib/gui/GToolbarElement.h"
#include "glib/gui/GAbstractToolbarWindow.h"

/**
 * @author  Leif Erik Larsen
 * @since   2001.03.07
 */
class GToolbarSeparator : public GToolbarElement
{
   private:

      class GAbstractToolbarWindow& ownerTB;

   public:

      GToolbarSeparator ( GAbstractToolbarWindow& ownerTB, 
                          const GString& constraints );

      virtual ~GToolbarSeparator ();

   private:

      /** Disable the copy constructor. */
      GToolbarSeparator ( const GToolbarSeparator& src ) 
         : GToolbarElement(GString::Empty, GString::Empty, *this), ownerTB(src.ownerTB) {}

      /** Disable the assignment operator. */
      GToolbarSeparator& operator= ( const GToolbarSeparator& ) { return *this; }

   protected:

      virtual bool onBackgroundColorChanged ( const GColor& color );
      virtual bool onPaint ( GGraphics& g, const GRectangle& rect );

   public:

      int getPreferredHeight () const { return 20 + 8; };
      int getPreferredWidth () const { return 8; };
};

#endif


