/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/GToolbarElement.h"
#include "glib/util/GLog.h"

GToolbarElement::GToolbarElement ( const GString& name,
                                   const GString& constraints,
                                   GWindow& parentWin,
                                   long winStyle,
                                   int winStyle2 )
                :GWindow(name,
                         constraints,
                         &parentWin,
                         &parentWin,
                         winStyle,
                         winStyle2)
{
}

GToolbarElement::~GToolbarElement ()
{
}

bool GToolbarElement::isFirstVisibleToolbarElement () const
{
   GWindow& tb = *getParentWindow();

   const int num = tb.getChildWindowCount();
   for (int i=0; i<num; i++)
   {
      const GWindow& elm = const_cast<const GWindow&>(tb.getChildWindow(i));
      if (elm.isVisible())
         return &elm == this;
   }

   return false;
}
