/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_STATICICON
#define __GLIB_STATICICON

#include "glib/gui/GWindow.h"

/**
 * This is the low level window class that is used to paint a static
 * icon in a container window.
 *
 * @author  Leif Erik Larsen
 * @since   2000.09.22
 */
class GStaticIcon : public GWindow
{
   private:

      GString iconName;

   public:

      GStaticIcon ( const GString& name,
                    const GString& constraints,
                    GWindow& parentWin,
                    const GString& iconName = GString::Empty,
                    long winStyle = WS_VISIBLE,
                    long winStyle2 = 0 );

      virtual ~GStaticIcon ();

   private:

      /** Disable the copy constructor. */
      GStaticIcon ( const GStaticIcon& src ) {}

      /** Disable the assignment operator. */
      GStaticIcon& operator= ( const GStaticIcon& ) { return *this; }

   protected:

      virtual bool onPaint ( GGraphics& g, const GRectangle& rect );
      virtual bool onPaintBackground ( GGraphics& g, const GRectangle& rect );

   public:

      /**
       * Get a pointer to the current icon of this component,
       * or null if the component has no current icon at all.
       *
       * @author  Leif Erik Larsen
       * @since   2004.03.08
       */
      const GIcon* getIcon () const;

      /**
       * Set the icon that is to be painted on this static icon component. 
       *
       * @author  Leif Erik Larsen
       * @since   2004.03.08
       * @param   iconName  The name of which icon to activate. This icon 
       *                    must exist in the default resource table of the 
       *                    application. If it does not exist, then we will 
       *                    silently ignore it, and no icon will be painted
       *                    on the component at all.
       * @return  True if the icon was activated, or false if it could 
       *          not be found in the resource table of the application.
       */
      bool setIcon ( const GString& iconName );
};

#endif

