/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_PROGRESSBAR
#define __GLIB_PROGRESSBAR

#include "glib/gui/GWindow.h"

#define GPROGRESSBAR_DEFAULT_FONT "8.Helv"

/**
 * This is the low level window class that is used to paint a progress
 * bar in a container window.
 *
 * @author  Leif Erik Larsen
 * @since   2000.10.09
 */
class GProgressBar : public GWindow
{
   private:

      bool horizontal;
      int minValue;
      int maxValue;
      int curValue;

   public:

      GProgressBar ( const GString& name,
                     const GString& constraints,
                     GWindow& parentWin,
                     long winStyle = WS_VISIBLE,
                     long winStyle2 = 0,
                     int minValue = 0,
                     int maxValue = 100,
                     bool horizontal = true );

      virtual ~GProgressBar ();

   private:

      /** Disable the copy constructor. */
      GProgressBar ( const GProgressBar& src ) {}

      /** Disable the assignment operator. */
      GProgressBar& operator= ( const GProgressBar& ) { return *this; }

   protected:

      virtual bool onPaint ( GGraphics& g, const GRectangle& rect );

   public:

      virtual bool isEmpty () const;
      virtual void changeValue ( const GString& newValue, bool notify = true );
      virtual GString queryValue () const;

      int getCurrentValue () const { return curValue; }
      int getMaxValue () const { return maxValue; }
      int getMinValue () const { return minValue; }

      bool isHorizontal () const { return horizontal; }

      void setCurrentValue ( int cur );
      void setMaxValue ( int max );
      void setMinValue ( int min );

      /**
       * Set whether this progress bar shall be displayed horisontal
       * or vertical.
       *
       * @author  Leif Erik Larsen
       * @since   2000.10.09
       */
      void setHorisontal ( bool flag );
};

#endif

