/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/GListBoxItem.h"

GListBoxItem::GListBoxItem ()
             :text(),
              icon(null),
              userData(null),
              autoDeleteUserData(false)
{
}

GListBoxItem::GListBoxItem ( const GListBoxItem& src )
             :GObject(src),
              text(src.text),
              icon(src.icon),
              userData(src.userData),
              autoDeleteUserData(false)
{
}

GListBoxItem::GListBoxItem ( const GString& text )
             :text(text),
              icon(null),
              userData(null),
              autoDeleteUserData(false)
{
}

GListBoxItem::GListBoxItem ( const GString& text, const class GIcon* icon )
             :text(text),
              icon(icon),
              userData(null),
              autoDeleteUserData(false)
{
}

GListBoxItem::GListBoxItem ( const GString& text, GObject* userData, bool autoDeleteUserData )
             :text(text),
              icon(null),
              userData(userData),
              autoDeleteUserData(autoDeleteUserData)
{
}

GListBoxItem::GListBoxItem ( const GString& text, const class GIcon* icon, GObject* userData, bool autoDeleteUserData )
             :text(text),
              icon(icon),
              userData(userData),
              autoDeleteUserData(autoDeleteUserData)
{
}

GListBoxItem::~GListBoxItem ()
{
   if (autoDeleteUserData)
      delete userData;
}

GListBoxItem& GListBoxItem::operator= ( const GListBoxItem& src )
{
   if (this == &src)
      return *this;
   text = src.text;
   icon = src.icon;
   userData = src.userData;
   autoDeleteUserData = src.autoDeleteUserData;
   return *this;
}

bool GListBoxItem::operator== ( const GListBoxItem& src ) const
{
   if (this == &src)
      return true;
   else
      return text == src.text &&
             icon == src.icon &&
             userData == src.userData;
}

bool GListBoxItem::operator!= ( const GListBoxItem& src ) const 
{ 
   return !operator==(src); 
}

const GIcon* GListBoxItem::getIcon () const 
{ 
   return icon; 
}

const GString& GListBoxItem::getText () const 
{ 
   return text; 
}

GObject* GListBoxItem::getUserData () const 
{ 
   return userData; 
}

void GListBoxItem::setIcon ( const class GIcon* newIcon ) 
{ 
   icon = newIcon; 
}

void GListBoxItem::setText ( const GString& newText ) 
{ 
   text = newText; 
}

void GListBoxItem::setUserData ( GObject* ud, bool autoDelete ) 
{ 
   userData = ud; 
   autoDeleteUserData = autoDelete; 
}

GString GListBoxItem::toString () const 
{ 
   return getText(); 
}
