/* --------------------------------------------------------------------------
 *
 * This file was part of the "More for C++" library.
 * Copyright (c) 1999-2003 by Thorsten Goertz.
 * The "More for C++" library is free software; you can
 * redistribute it and/or modify it under the terms of the license
 * that comes with http://www.morefor.org/.
 *
 * ------------------------------------------------------------------------ */

#include <cstddef>
#include "glib/gc/objectstack.h"

const size_t SIZE_OF_STACKED_OBJECTS = 1000;

struct ObjectStack::StackedObjects
{
  StackedObjects*   m_pPrevObjects;
  size_t            m_nNoOfObjects;
  void*             m_pObjects[SIZE_OF_STACKED_OBJECTS];
};

ObjectStack::ObjectStack( ): m_pStackedObjects( 0 )
{
}

ObjectStack::~ObjectStack( )
{
  while( m_pStackedObjects != 0 )
  {
    StackedObjects* pObjects = m_pStackedObjects;

    m_pStackedObjects = pObjects -> m_pPrevObjects;
    delete pObjects;
  }
}

bool ObjectStack::isEmpty () const
{
  return m_pStackedObjects == 0;
}

void ObjectStack::pushObject ( void* pObject )
{
  if( m_pStackedObjects == 0 || m_pStackedObjects -> m_nNoOfObjects == SIZE_OF_STACKED_OBJECTS )
  {
    StackedObjects* pObjects;

    pObjects = new StackedObjects;
    pObjects -> m_pPrevObjects = m_pStackedObjects;
    pObjects -> m_nNoOfObjects = 0;
    m_pStackedObjects = pObjects;
  }

  size_t& rnNoOfObjects = m_pStackedObjects -> m_nNoOfObjects;
  m_pStackedObjects -> m_pObjects[rnNoOfObjects++] = pObject;
}

void* ObjectStack::popObject ()
{
  void* pResult = 0;

  if( m_pStackedObjects != 0 )
  {
    size_t& rnNoOfObjects = m_pStackedObjects -> m_nNoOfObjects;

    pResult = m_pStackedObjects -> m_pObjects[--rnNoOfObjects];

    if( rnNoOfObjects == 0 )
    {
      StackedObjects* pObjects = m_pStackedObjects;

      m_pStackedObjects = pObjects -> m_pPrevObjects;
      delete pObjects;
    }
  }

  return pResult;
}
