/* --------------------------------------------------------------------------
 *
 * This file was part of the "More for C++" library.
 * Copyright (c) 1999-2003 by Thorsten Goertz.
 * The "More for C++" library is free software; you can
 * redistribute it and/or modify it under the terms of the license
 * that comes with http://www.morefor.org/.
 *
 * ------------------------------------------------------------------------ */

#include "glib/gc/gc.h"
#include "glib/gc/gcimpl.h"

void GC::Adapter::InitPointer ( void**& rppObject,
                                void* pObject,
                                GObject* pFinalizable )
{
   GCImpl::InitPointer(rppObject, pObject, pFinalizable);
}

void GC::Adapter::AssignObject ( void**& rppObject,
                                 void* pObject,
                                 GObject* pFinalizable )
{
   if (*rppObject != pObject)
   {
      bool bIsRootPointer = GCImpl::IsRootPointer(rppObject);
      GCImpl::ForgetObject(rppObject, bIsRootPointer);
      GCImpl::AssignObject(rppObject, pObject, pFinalizable, bIsRootPointer);
   } 
}

void GC::Adapter::ForgetObject ( void**& rppObject )
{
   bool bIsRootPointer = GCImpl::IsRootPointer(rppObject);
   GCImpl::ForgetObject(rppObject, bIsRootPointer);
}

void GC::StartCollectorThread ()
{
   GCImpl::StartCollectorThread();
}

void GC::StopCollectorThread ()
{
   GCImpl::StopCollectorThread();
}

int GC::GetNoOfObjects ()
{
   return GCImpl::GetNoOfObjects();
}

void GC::CollectObjects ( bool force )
{
   GCImpl::CollectObjects(force);
}
