/* --------------------------------------------------------------------------
 *
 * This file was part of the "More for C++" library.
 * Copyright (c) 1999-2003 by Thorsten Goertz.
 * The "More for C++" library is free software; you can
 * redistribute it and/or modify it under the terms of the license
 * that comes with http://www.morefor.org/.
 *
 * ------------------------------------------------------------------------ */

#include <cstdlib>
#include <malloc.h>
#include "glib/gc/defaultheapmanager.h"

void* DefaultHeapManager::createObject ( size_t nSizeOfObject )
{
   return malloc(nSizeOfObject);
}

void DefaultHeapManager::destroyObject ( void* pObject )
{
   free(pObject);
}

void DefaultHeapManager::compactHeap ()
{
   // Return as much as possible of the unused space on the heap to the OS.
   _heapmin();
}
