/* --------------------------------------------------------------------------
 *
 * This file was part of the "More for C++" library.
 * Copyright (c) 1999-2003 by Thorsten Goertz.
 * The "More for C++" library is free software; you can
 * redistribute it and/or modify it under the terms of the license
 * that comes with http://www.morefor.org/.
 *
 * ------------------------------------------------------------------------ */

#ifndef MORE_CREATE_HPP
#define MORE_CREATE_HPP

enum NewAndDeleteOperators 
{
   MORE_NEW_AND_DELETE_OPERATORS
};

void* operator new ( size_t, NewAndDeleteOperators );

#if __HAS_PLACEMENT_DELETE_OPERATOR__
/**
 * The placement "delete" operator must never be used manually! It's only
 * purpose is for objects who could not be assigned to a pointer because
 * their constructor threw an exception. For those cases the compiler
 * generates code that will call the "delete" operator implicitly and
 * destroy each member of the freshly created object. Be aware
 * that for those objects there will be no finalization!
 */
void operator delete ( void*, NewAndDeleteOperators );
#endif

//  Objects will be referenced by pointers to pointers to Objects. Only Objects
//  that had been created by this "More for C++" placement "new" operator will
//  be handled by the Garbage Collector!

/**
 * Define "CREATE" because "pFoo = CREATE Foo();"
 * looks much better than  "pFoo = new(GC::MORE_NEW_AND_DELETE_OPERATORS) Foo()"
 */
#define CREATE new(MORE_NEW_AND_DELETE_OPERATORS)

#endif
