/* --------------------------------------------------------------------------
 *
 * This file was part of the "More for C++" library.
 * Copyright (c) 1999-2003 by Thorsten Goertz.
 * The "More for C++" library is free software; you can
 * redistribute it and/or modify it under the terms of the license
 * that comes with http://www.morefor.org/.
 *
 * ------------------------------------------------------------------------ */

#include <memory.h>
#include "glib/gc/bitmask.h"

size_t BitMask::calcSize ( size_t nNoOfBits )
{
   return ( nNoOfBits + 7 ) >> 3;
}

BitMask::BitMask ( byte* pBytesForBits, size_t  nNoOfBytes, size_t  nNoOfBits )
{
   initialize( pBytesForBits, nNoOfBytes, nNoOfBits );
}

void BitMask::initialize ( byte* pBytesForBits, size_t  nNoOfBytes, size_t  nNoOfBits )
{
   m_pBytesForBits = pBytesForBits;
   m_nNoOfBytes = nNoOfBytes;
   m_nNoOfBits = nNoOfBits;
}

size_t BitMask::getNoOfBits () const
{
   return m_nNoOfBits;
}

void BitMask::clear ()
{
  if (m_pBytesForBits != 0)
     memset( m_pBytesForBits, 0, m_nNoOfBytes );
}

void BitMask::setBit ( size_t nIndex, bool bValue )
{
  size_t  nIndexOfByte = nIndex / 8;
  byte    nMask = byte( 0x80 >> nIndex % 8 );
  byte&   rnByte = m_pBytesForBits[nIndexOfByte];

   if( rnByte == 0 )
   {
      rnByte = nMask;
   }
   else
   {
      if( bValue == true )
      {
         rnByte |= nMask;
      }
      else
      {
         rnByte &= 0xFF ^ nMask;
      }
   }
}

bool BitMask::getBit ( size_t nIndex ) const
{
   size_t nIndexOfByte = nIndex / 8;
   byte nByte = m_pBytesForBits[nIndexOfByte];
   if( nByte != 0 )
      nByte &= byte( 0x80 >> nIndex % 8 );
   return nByte != 0;
}
