/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_SYNTAXERROREXCEPTION
#define __GLIB_SYNTAXERROREXCEPTION

#include "glib/exceptions/GException.h"

/**
 * This exception can be used in general to signal an error in a
 * string or stream being parsed.
 *
 * @author  Leif Erik Larsen
 * @since   2000.07.29
 */
class GSyntaxErrorException : public GException
{
   private:

      int columnPos;
      int lineNum;

   public:

      explicit GSyntaxErrorException ( const char* msg, int columnPos = 0, int lineNum = 0 );

   public:

      int getColumnPos () const { return columnPos; }
      int getLineNumber () const { return lineNum; }
};

#endif


