/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_EXCEPTION
#define __GLIB_EXCEPTION

#include "glib/primitives/GString.h"
#include "glib/sys/GError.h"
#include "glib/sys/GSymbolEngine.h"

/**
 * The base class of all exception types of the G-library.
 *
 * @author  Leif Erik Larsen
 * @since   1999.10.22
 */
class GException : public GObject, public std::exception
{
   private:

      GString msg;
      GError sysErr;
      mutable GString bareStackTrace;
      mutable GString msgFullText;

      /** Postpone fetching the stacktrace if this is != null. */
      mutable GSymbolEngine::ThreadContext* context; 

   public:

      explicit GException ( const char* msg, 
                            GError sysErr = GError::Ok,
                            GSymbolEngine::ThreadContext* context = null );

      virtual ~GException ();

   public:

      GString getMessage () const;
      GError getSystemErrorCode () const;
      void setMessage ( const char* msg );
      GString getStackTrace ( const GString& msg ) const;
      virtual GString toString () const;
      virtual const char* what() const throw();

#ifndef GTHROW_NO_LOGGING
      /**
       * This method is public as an implementation side effect, so don't
       * use it.
       *
       * It is to be used by the <i>gthrow_</i> macro only.
       *
       * @author  Leif Erik Larsen
       * @since   2000.10.19
       */
      void logForGThrow ( const char* moduleName, int lineNr ) const;
#endif
};

#endif
